//********************************************************************
//  Fence.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.27 (5E, p. 289)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class Fence extends JApplet
{
   private final int NUM_SLATS = 15;
   private final int SLAT_WIDTH = 15;
   private final int SLAT_HEIGHT = 80;
   private final int GAP = 12;
   private final int FENCE_Y = 170;
   private final int WIDTH = 400;

   //-----------------------------------------------------------------
   //  Paints a fence with a house behind it.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int x = GAP;

      setBackground (Color.cyan);

      page.setColor (Color.green);
      page.fillRect (0, FENCE_Y+60, WIDTH, 40);  // yard

      page.setColor (Color.gray);
      page.fillRect (45, FENCE_Y-60, WIDTH-85, 130);  // house

      page.setColor (Color.blue);
      page.fillRect (40, FENCE_Y-100, WIDTH-75, 40);  // roof

      page.setColor (Color.red);
      page.fillRect (180, FENCE_Y-20, 40, 90);  // door

      page.setColor (Color.white);
      page.fillRect (0, FENCE_Y+20, WIDTH, 10);  // fence support
      page.fillRect (0, FENCE_Y+50, WIDTH, 10);  // fence support

      for (int slat=1; slat <= NUM_SLATS; slat++)  // fence slats
      {
         page.fillRect (x, FENCE_Y, SLAT_WIDTH, SLAT_HEIGHT);
         x += SLAT_WIDTH + GAP;
      }
   }
}
